/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.display;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.npc.Villager;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class EntityDisplay {
    private static final float RENDER_HEIGHT = 30.0f;
    private static final float RENDER_WIDTH = 18.0f;
    private static final float WIDTH = 40.0f;
    private static final float HEIGHT = 40.0f;
    private LivingEntity entity;
    private int entityScale = 1;
    private float xOffset;
    private float yOffset;

    public void setEntity(LivingEntity entity) {
        this.entity = entity;
        this.updateScale();
    }

    public void draw(PoseStack matrix, float scale) {
        if (this.entity != null) {
            try {
                EntityDisplay.drawEntity(matrix, (int)this.xOffset, (int)this.yOffset, this.entityScale, -80.0f, -20.0f, this.entity, scale);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void updateScale() {
        if (this.entity == null) {
            return;
        }
        int scaleY = Mth.m_14167_((float)(30.0f / this.entity.m_20206_()));
        int scaleX = Mth.m_14167_((float)(18.0f / this.entity.m_20206_()));
        this.entityScale = Math.min(scaleX, scaleY);
        if (this.entity instanceof Chicken) {
            this.entityScale = (int)((double)this.entityScale * 0.7);
        }
        if (this.entity instanceof Villager && this.entity.m_5803_()) {
            this.entityScale = this.entity.m_6162_() ? 31 : 16;
        }
        this.xOffset = 20.0f;
        this.yOffset = 35.0f;
        if (this.entity instanceof Ghast) {
            this.yOffset -= 10.0f;
        }
    }

    public static void drawEntity(PoseStack matrixStack2, int x, int y, int size, float mouseX, float mouseY, LivingEntity entity, float scale) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float g = (float)Math.atan(mouseY / 40.0f);
        PoseStack matrixStack = RenderSystem.getModelViewStack();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x * (double)scale, (double)y * (double)scale, 1050.0 * (double)scale);
        matrixStack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        matrixStack2.m_85836_();
        matrixStack2.m_85837_(0.0, 0.0, 1000.0);
        matrixStack2.m_85841_((float)size, (float)size, (float)size);
        Quaternionf quaternion = Axis.f_252403_.m_252977_(180.0f);
        Quaternionf quaternion2 = Axis.f_252529_.m_252977_(g * 20.0f);
        matrixStack2.m_252781_(quaternion.mul((Quaternionfc)quaternion2));
        float h = entity.f_20883_;
        float i = entity.m_146908_();
        float j = entity.m_146909_();
        float k = entity.f_20886_;
        float l = entity.f_20885_;
        entity.f_20883_ = 180.0f + f * 20.0f;
        entity.m_146922_(180.0f + f * 40.0f);
        entity.m_146926_(-g * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        Lighting.m_166384_();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        entityrenderdispatcher.m_252923_(quaternion2.conjugate());
        entityrenderdispatcher.m_114468_(false);
        MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.runAsFancy(() -> entityrenderdispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack2, (MultiBufferSource)immediate, 0xF000F0));
        immediate.m_109911_();
        entityrenderdispatcher.m_114468_(true);
        entity.f_20883_ = h;
        entity.m_146922_(i);
        entity.m_146926_(j);
        entity.f_20886_ = k;
        entity.f_20885_ = l;
        matrixStack.m_85849_();
        matrixStack2.m_85849_();
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
    }
}

